clear all
set mem 1500m

use "..\Proprietary\The_Gallup_101510.dta"
set more off
* Data cleaning
foreach v of varlist _all {
	local l=lower("`v'") 
	cap rename `v' `l'
}
gen wt=wgt
gen str3 cty=""
for ! in num 1 2 3 4 5 6 8 9 \ @ in any USA EGY MAR LBN SAU JOR TUR PAK: replace cty="@" if wp5==!
for ! in num 10/19 \ @ in any IDN BGD GBR FRA DEU NLD BEL ESP ITA POL: replace cty="@" if wp5==!
for ! in num 20/29 \ @ in any HUN CZE ROU SWE GRC DNK IRN HKG SGP JPN: replace cty="@" if wp5==!
for ! in num 30/39 \ @ in any CHN IND VEN BRA MEX NGA KEN TZA ISR PSE: replace cty="@" if wp5==!
for ! in num 40/49 \ @ in any GHA UGA BEN MDG MWI ZAF CAN AUS PHL LKA: replace cty="@" if wp5==!
for ! in num 50/57 \ @ in any VNM THA KHM LAO MMR NZL AGO BWA: replace cty="@" if wp5==! 
for ! in num 60/69 \ @ in any ETH MLI MRT MOZ NER RWA SEN ZMB KOR TWN: replace cty="@" if wp5==!
for ! in num 70/79 \ @ in any AFG BLR GEO KAZ KGZ MDA RUS UKR BFA CMR: replace cty="@" if wp5==!
for ! in num 80 81 82 83 84 87 88 89 \ @ in any SLE ZWE CRI ALB DZA ARG ARM AUT: replace cty="@" if wp5==!
for ! in num 90 96 97 99 \ @ in any AZE BOL BIH BGR: replace cty="@" if wp5==! 
for ! in num 100 103 104 105 109 \ @ in any BDI TCD CHL COL HRV: replace cty="@" if wp5==!
for ! in num 110 111 114 115 116 119 \ @ in any CUB CYP DOM ECU SLV EST: replace cty="@" if wp5==!
for ! in num 121 124 128 129 \ @ in any FIN GTM HTI HND: replace cty="@" if wp5==!
for ! in num 131 132 135 137 138 \ @ in any IRQ IRL JAM KWT LVA: replace cty="@" if wp5==!
for ! in num 143 145 146 \ @ in any LTU MKD MYS: replace cty="@" if wp5==!
for ! in num 154 157 158 \ @ in any MNE NPL NIC: replace cty="@" if wp5==!
for ! in num 160 163 164 165 166 167 \ @ in any NOR PAN PRY PER PRT PRI: replace cty="@" if wp5==!
for ! in num 173 175 176 \ @ in any SRB SVK SVN: replace cty="@" if wp5==!
for ! in num 184 185 187 189 \ @ in any CHE TJK TGO TTO: replace cty="@" if wp5==!
for ! in num 193 194 195 197 198 \ @ in any ARE URY UZB YEM UNK: replace cty="@" if wp5==!
for ! in num 7   92  94  102 106 107 108 112 125 127 130 134 140 141 144 148 153 155 168 181 190 191 \ @ in any SYR BHR BLZ CAF COM COD COG DJI GIN GUY ISL CIV LBR LBY LUX MLT MNG NAM QAT SDN TUN TKM : replace cty="@" if wp5==!
replace cty="SOM" if wp5==199 /* I'm calling Somaliland Somalia; not quite right*/
tab wp5 if cty==""
gen oecd=0
for ! in any AUT BEL CAN DNK FRA DEU GRC ISL IRL ITA LUX NLD NOR PRT ESP SWE CHE TUR GBR ///
    USA JPN FIN AUS NZL MEX CZE KOR HUN POL SVK: replace oecd=1 if cty=="!"

rename wp1219 sex
rename wp1220 age
rename wp1223 marital
rename wp14 urbanrural
rename wp3117 educ


gen sat_current=wp16
la var sat "Current Life Satisfaction"
gen sat_past=wp17
la var sat_past "Life Satisfaction 5 years ago"
gen sat_future=wp18
la var sat_future "Expected Life Satisfaction in 5 years"
cap gen sat_life=wp4656
cap la var sat_life "Satisfaction with Life as a Whole"

#delimit;
for X in var wp59 wp60 wp61 wp62 wp63 wp64 wp65 wp66 \ 
	Y in any moredays wellrested respect choose smile proud lean goodfood: 
	gen yesterday_Y=X;

for X in any moredays wellrested respect choose smile proud lean goodfood \
	Y in any "Would you like to have more days just like yesterday?" "Did you feel well rested
    yesterday?" "Were you treated with respect all day yesterday?" "Were you able to choose
    how you spent your time all day?" "Did you smile or laugh a lot yesterday?" "Were you
    proud of something you did yesterday?" "Did you learn or do something interesting
    yesterday?" "Did you have good tasting food to eat yesterday?" : la var yesterday_X "Y";

for X in var wp67 wp68 wp69 wp70 wp71 wp72 wp73 wp74  wp76 \ 
	Y in any enjoyment pain worry sadness stress boredom depression anger love: 
	gen feelings_Y=X;

for X in any enjoyment pain worry sadness boredom depression anger love \ 
	Y in any "Enjoyment" "Physical Pain" "Worry" "Sadness" "Boredom" "Depression" "Anger" "Love" : la
    var feelings_X "Y";

for X in var wp138 wp139 wp141 wp143 \ Y in any  judicial govt finance media:
	rename X conf_Y;

* Deal with missing values;
for var sat_*: replace X=. if X==98 | X==99;
for var yesterday_* feelings_* conf_*: replace X=. if X==3 | X==4;
label define yesno 0 "No" 1 "yes";
for var yesterday_* feelings_* conf_*: replace X=0 if X==2 \ label values X yesno;
    label define educ 1 "Primary or less" 2 "Secondary-3 year Tertiary" 3 "4 year Tertiary or
    more";

#delimit cr

label values educ educ
for var educ: replace X=. if X==4 | X==5
* Merge in data
gen year=int(wave)+2005
replace wave=int(wave)
sort cty year
merge m:1 cty year using "Unemployment rates", keep(match master)
tab cty _merge
drop _merge

drop wp* region* index*
compress
save "..\Proprietary\Gallup_work", replace


